/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.model.interpreter;

import cds.savot.model.interpreter.BinaryFieldInterpreter;
import cds.savot.model.interpreter.BinaryInterpreterException;
import cds.savot.model.interpreter.LongInterpreter;

public class DoubleInterpreter
extends BinaryFieldInterpreter<Double> {
    private final LongInterpreter longDecoder = new LongInterpreter();

    public DoubleInterpreter() throws BinaryInterpreterException {
        this(new int[]{1});
    }

    public DoubleInterpreter(int[] arraysizes) throws BinaryInterpreterException {
        super(arraysizes, "double value", 8);
    }

    @Override
    public Double decodePrimary(byte[] bytes, int offset) throws BinaryInterpreterException {
        return Double.longBitsToDouble(this.longDecoder.decodePrimary(bytes, offset));
    }

    @Override
    protected Class<Double[]> getArrayClass() {
        return Double[].class;
    }

    @Override
    protected Double convertPrimary(Object value) throws BinaryInterpreterException {
        if (value == null) {
            return Double.NaN;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException nfe) {
                throw new BinaryInterpreterException("Impossible to convert \"" + value + "\" into a Double: " + nfe.getMessage() + " !");
            }
        }
        throw new BinaryInterpreterException("Impossible to convert a " + value.getClass().getName() + " into a Double !");
    }

    @Override
    public byte[] encodePrimary(Double value) throws BinaryInterpreterException {
        if (value == null) {
            value = Double.NaN;
        }
        return this.longDecoder.encodePrimary(Double.doubleToRawLongBits(value));
    }
}

